// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OATwoLayerWindow.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OATwoLayerWindow.m,v 1.4 1998/12/08 04:07:33 kc Exp $")

@implementation OATwoLayerWindow

// Init and dealloc


- (void)dealloc
{
    [extraWindowDrawer release];
    extraWindowDrawer = nil;
    [super dealloc];
}


// API

- (void)setExtraWindowDrawer:(id <OAExtraWindowDrawing>)newExtraWindowDrawer;
{
    if (extraWindowDrawer == newExtraWindowDrawer)
        return;

    [extraWindowDrawer release];
    extraWindowDrawer = [newExtraWindowDrawer retain];
}


// NSWindow subclass

- (void)flushWindow;
{
    if (!extraWindowDrawer) {
        [super flushWindow];
        return;
    }

    if ([self isFlushWindowDisabled] || [self backingType] != NSBackingStoreBuffered || [self windowNumber] <= 0 || ![[NSDPSContext currentContext] isDrawingToScreen]) {
        [super flushWindow]; // This probably will do nothing, but better to be safe.
        return;
    }

    [extraWindowDrawer windowWillFlush:self];
    [super flushWindow];
    [extraWindowDrawer windowDidFlush:self];
}

// - (BOOL)_confirmSize:(NSSize *)size;


@end
