// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAColorPalette.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OAColorPalette.m,v 1.4 1998/12/08 04:07:15 kc Exp $")

@implementation OAColorPalette

static NSDictionary *namedColorsDictionary = nil;

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
	return;
    initialized = YES;

    namedColorsDictionary = [[NSDictionary alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"namedColors" ofType:@"dictionary"]];
}

+ (NSColor *)colorForString:(NSString *)colorString;
{
    unsigned int rawColor;
    unsigned int red, green, blue;

    if ([colorString hasPrefix:@"#"]) {
        // Hex color string
	colorString = [colorString substringFromIndex:1];
    } else {
        NSString *namedColorString;

        // Possibly a named color string
        namedColorString = [namedColorsDictionary objectForKey:[colorString lowercaseString]];
        if (namedColorString)
            colorString = namedColorString;
    }
    
    rawColor = [colorString hexValue];
    blue = rawColor & 0xff;
    rawColor >>= 8;
    green = rawColor & 0xff;
    rawColor >>= 8;
    red = rawColor & 0xff;
    return [NSColor colorWithCalibratedRed:red / 255.0 green:green / 255.0 blue:blue / 255.0 alpha:0.0];
}

+ (NSString *)stringForColor:(NSColor *)color;
{
    float red, green, blue, alpha;

    if (![[color colorSpaceName] hasSuffix:@"RGBColorSpace"])
        color = [color colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
    [color getRed:&red green:&green blue:&blue alpha:&alpha];

    // Note: alpha is currently ignored
    return [NSString stringWithFormat:@"#%06x", (((int)ceil(red * 255.0)) << 16) | (((int)ceil(green * 255.0)) << 8) | ((int)ceil(blue * 255.0))];
}

@end
