// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Preferences.subproj/OAPreferenceController.h,v 1.4 1998/12/08 04:07:10 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSMutableArray, NSMutableDictionary;
@class NSBox, NSImageView, NSTableView, NSTextField, NSWindow;
@class OAPreferenceClient, OAPreferenceController;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@interface OAPreferenceController : OFObject
{
    IBOutlet NSWindow *window;
    IBOutlet NSBox *box;
    IBOutlet NSTableView *tableView;
    IBOutlet NSTextField *titleTextField;
    IBOutlet NSImageView *imageView;

    NSString *categoryName;
    OAPreferenceClient *currentClient;
    NSMutableArray *clientRecordsArray;
    NSMutableDictionary *clientClassNamesToClientRecordDictionary;
    NSMutableDictionary *clientClassNamesToInstancesDictionary;
}

+ (OAPreferenceController *)sharedPreferenceControllerNamed:(NSString *)categoryName;
+ (OAPreferenceController *)sharedPreferenceController;

- initWithCategoryName:(NSString *)controllerCategoryName;

// API
- (OAPreferenceClient *)clientNamed:(NSString *)clientName;
- (void)close;

// Actions
- (IBAction)showPreferencesPanel:(id)sender;
- (IBAction)selectPreference:(NSTableView *)sender;
- (IBAction)restoreDefaults:(id)sender;


@end
