// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAPreferenceClientRecord.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Preferences.subproj/OAPreferenceClientRecord.m,v 1.4 1998/12/08 04:07:10 kc Exp $")

@implementation OAPreferenceClientRecord

- (void)dealloc
{
    [className release];
    [title release];
    [iconName release];
    [iconTitle release];
    [nibName release];
    [defaultsDictionary release];
    [defaultsArray release];
    [iconImage release];
    [super dealloc];
}


//

- (NSImage *)iconImage;
{
    if (iconImage)
        return iconImage;

    iconImage = [[NSImage alloc] initWithContentsOfFile:[[OFBundledClass bundleForClassNamed:className] pathForResource:iconName ofType:@"tiff"]];
    return iconImage;
}

- (NSString *)className;
{
    return className;
}

- (NSString *)title;
{
    return title;
}

- (NSString *)iconName;
{
    return iconName;
}

- (NSString *)iconTitle;
{
    return iconTitle;
}

- (NSString *)nibName;
{
    return nibName;
}

- (NSDictionary *)defaultsDictionary;
{
    return defaultsDictionary;
}

- (NSArray *)defaultsArray;
{
    return defaultsArray;
}

- (float)ordering;
{
    return ordering;
}

- (void)setClassName:(NSString *)newClassName;
{
    if (className == newClassName)
        return;
    [className release];
    className = [newClassName retain];
}

- (void)setTitle:(NSString *)newTitle;
{
    if (title == newTitle)
        return;
    [title release];
    title = [newTitle retain];
}

- (void)setIconName:(NSString *)newIconName;
{
    if (iconName == newIconName)
        return;
    [iconName release];
    iconName = [newIconName retain];
}

- (void)setIconTitle:(NSString *)newIconTitle;
{
    if (iconTitle == newIconTitle)
        return;
    [iconTitle release];
    iconTitle = [newIconTitle retain];
}

- (void)setNibName:(NSString *)newNibName;
{
    if (nibName == newNibName)
        return;
    [nibName release];
    nibName = [newNibName retain];
}

- (void)setDefaultsDictionary:(NSDictionary *)newDefaultsDictionary;
{
    if (defaultsDictionary == newDefaultsDictionary)
        return;
    [defaultsDictionary release];
    defaultsDictionary = [newDefaultsDictionary retain];
}

- (void)setDefaultsArray:(NSArray *)newDefaultsArray;
{
    if (defaultsArray == newDefaultsArray)
        return;
    [defaultsArray release];
    defaultsArray = [newDefaultsArray retain];
}

- (void)setOrdering:(float)newOrdering;
{
    ordering = newOrdering;
}

- (NSComparisonResult)compare:(OAPreferenceClientRecord *)other;
{
    if (![other isKindOfClass:[self class]])
	return NSOrderedAscending;

    if (other->ordering > ordering)
	return NSOrderedAscending;
    if (other->ordering < ordering)
	return NSOrderedDescending;
    return NSOrderedSame;
}


@end
