// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAPreferenceClient.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OAPreferenceController.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Preferences.subproj/OAPreferenceClient.m,v 1.5 1998/12/08 04:07:08 kc Exp $")

@implementation OAPreferenceClient

- initWithTitle:(NSString *)newTitle defaultsArray:(NSArray *)newDefaultsArray;
{
    if (![super init])
	return nil;

    title = [newTitle copy];
    defaultsArray = [newDefaultsArray retain];
    defaults = [OFUserDefaults sharedUserDefaults];
    return self;
}


// API

- (NSBox *)controlBox;
{
    return controlBox;
}

- (NSView *)initialFirstResponder;
{
    return initialFirstResponder;
}

- (IBAction)restoreDefaults:(id)sender;
{
    switch (NSRunAlertPanel(@"Restore Defaults",
                            @"Are you sure you wish to restore all the %@ to their original installation values?",
                            @"Restore", @"Cancel", nil, title)) {
        case NSAlertDefaultReturn:
            break;
        case NSAlertAlternateReturn:
        case NSAlertOtherReturn:
            return;
            break;
    }

    [self restoreDefaultsNoPrompt];
    [self valuesHaveChanged];
}

- (void)restoreDefaultsNoPrompt;
{
    NSEnumerator *defaultEnumerator;
    NSString *defaultName;

    defaultEnumerator = [defaultsArray objectEnumerator];
    while ((defaultName = [defaultEnumerator nextObject]))
	[defaults removeObjectForKey:defaultName];
}

- (void)pickDirectoryForTextField:(NSTextField *)textField;
{
    NSOpenPanel *openPanel;
    NSString *directory;

    openPanel = [NSOpenPanel new];
    [openPanel setCanChooseDirectories:YES];
    if ([openPanel runModalForTypes:nil] != NSOKButton)
	return;
    
    directory = [[openPanel filenames] objectAtIndex: 0];
    [textField setStringValue:directory];
    [self setValueForSender:textField];
}

- (void)resetFloatValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;
{
    [defaults removeObjectForKey:defaultName];
    [textField setFloatValue:[defaults floatForKey:defaultName]];
    NSBeep();
}

- (void)resetIntValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;
{
    [defaults removeObjectForKey:defaultName];
    [textField setIntValue:[defaults integerForKey:defaultName]];
    NSBeep();
}


// Subclass me!

- (void)updateUI;
{
}

- (void)setValueForSender:(id)sender;
{
}

- (void)valuesHaveChanged;
{
    [self updateUI];
}

 // Text delegate methods
 // (We have to be the field's text delegate because otherwise the field will just silently take the value if the user hits tab, and won't set the associated preference.)

- (void)controlTextDidEndEditing:(NSNotification *)notification;
{
    [self setValueForSender:[notification object]];
}


// NSNibAwaking informal protocol

- (void)awakeFromNib;
{
    [controlBox retain];
}


@end
