// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSBrowser-OAExtensions.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/OpenStepExtensions.subproj/NSBrowser-OAExtensions.m,v 1.2 1998/12/08 04:06:35 kc Exp $")

@implementation NSBrowser (OAExtensions)

- (NSString *)pathToCurrentItem;
{
    NSBrowserCell              *aCell;
    
    aCell = [self selectedCell];
    if (!aCell)
	return @"";
    
    return [NSString stringWithFormat:@"%@/%@",
        [self pathToColumn:[self lastColumn]], [aCell stringValue]];
}

- (NSString *)pathToNextItem;
{
    int                         column;
    int                         row;
    NSMatrix                   *aMatrix;
    int                         numRows;
    
    column = [self selectedColumn];
    if (column == -1)
	return @"";
    aMatrix = [self matrixInColumn:column];
    numRows = [aMatrix numberOfRows];
    row = [aMatrix selectedRow] + 1;
    if (row >= numRows)
	return nil;
    return [NSString stringWithFormat:@"%@/%@", [self pathToColumn:column],
        [[aMatrix cellAtRow:row column:0] stringValue]];
}

- (NSString *)pathToPreviousItem;
{
    int                         column;
    int                         row;
    int                         dummy;
    NSMatrix                   *aMatrix;
    NSArray                    *selectedCells;
    
    column = [self selectedColumn];
    if (column == -1)
	return @"";
    aMatrix = [self matrixInColumn:column];
    selectedCells = [self selectedCells];
    if (selectedCells)
	[aMatrix getRow:&row column:&dummy ofCell:[selectedCells objectAtIndex:0]];
    else  // does not return list if only 1 selected? (or set to allow only 1?)
	row = [aMatrix selectedRow];
    row--;
    if (row < 0)
	return nil;
    return [NSString stringWithFormat:@"%@/%@", [self pathToColumn:column],
        [[aMatrix cellAtRow:row column:0] stringValue]];
}

- (NSString *)pathToNextOrPreviousItem;
{
    NSString                   *path;
    
    path = [self pathToNextItem];
    if (!path)
	path = [self pathToPreviousItem];
    if (!path)
	path = [self pathToCurrentItem];
    
    return path;
}

- (NSString *)pathToCurrentColumn;
{
    return [self pathToColumn:[self lastColumn]];
}

@end
