// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/OAFindControllerTargetProtocol.h,v 1.7 1998/12/08 04:06:24 kc Exp $

#import <Foundation/NSObject.h>

@class NSView;
@class NSString;

@protocol OAFindControllerTarget
- (BOOL)findString:(NSString *)textPattern ignoreCase:(BOOL)ignoreCase backwards:(BOOL)backwards wrap:(BOOL)wrap;
@end

@interface NSObject (OAOptionalSelectedStringForFinding)
- (NSString *)selectedString;
@end

@interface NSObject (OAFindControllerAware)
- (id <OAFindControllerTarget>)omniFindControllerTarget;
@end

@protocol OASearchableContent
- (BOOL)findString:(NSString *)textPattern ignoreCase:(BOOL)ignoreCase backwards:(BOOL)backwards ignoreSelection:(BOOL)ignoreSelection;
@end

@interface NSObject (OAOptionalSearchableCellProtocol)
- (NSView <OASearchableContent> *)searchableContentView;
@end
