// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/OAFindController.h,v 1.7 1998/12/08 04:06:23 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSButton, NSForm, NSWindow;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet
#import "OAFindControllerTargetProtocol.h"

@interface OAFindController : OFObject
{
    IBOutlet NSWindow *findPanel;
    IBOutlet NSForm *searchTextForm;
    IBOutlet NSButton *ignoreCaseButton;
    IBOutlet NSButton *findNextButton;
    IBOutlet NSButton *findPreviousButton;
}

// Menu actions

- (IBAction)showFindPanel:(id)sender;
- (IBAction)findNext:(id)sender;
- (IBAction)findPrevious:(id)sender;
- (IBAction)enterSelection:(id)sender;

// Panel actions

- (IBAction)_findNext:(id)sender;
    // This action is sent by findNextButton
- (IBAction)_findPrevious:(id)sender;
    // This action is sent by findPreviousButton
- (IBAction)_findNextAndClosePanel:(id)sender;
    // This action is called when you hit return in searchTextForm

// Utility methods
- (void)saveFindText:(NSString *)string;
- (NSString *)restoreFindText;
- (id <OAFindControllerTarget>)target;

@end
