// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSData-OBObjectCompatibility.h"

#import <Foundation/Foundation.h>

#import "rcsid.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniBase/NSData-OBObjectCompatibility.m,v 1.4 1998/12/08 04:07:34 kc Exp $")

@implementation NSData (OBObjectCompatibility)

unsigned int NSDataShortDescriptionLength = 40;

- (NSString *)shortDescription;
{
    NSString                   *description;

    description = [self description];
    if ([description length] <= NSDataShortDescriptionLength)
	return description;
    return [[description substringToIndex:NSDataShortDescriptionLength]
            stringByAppendingString:@"..."];
}

@end

