/* NSView+DAPrinting.m created by aspinall on Tue 12-May-1998 */

#import "NSView+DAPrinting.h"

#import <ProjectBuilder/PBProjectExtras.h>

@implementation NSView (DAPrinting)

- (void)drawPageBorderWithSize:(NSSize)borderSize
{
    NSString	*string = nil;
    NSDPSContext *context = [NSDPSContext currentContext];
    
    /* Draw a header and footer lines. */
    /* don't you love magic numbers?  I suppose the user could pick their own indentation value, but we could also let the user pick a font and size .. Anyway, 30 pixels (printed) seem about right, so the line needs to drop a couple of extra pixels to accomodate the text, and the bottom has to lift a little extra for the same reason. */

    //if ( [[NSUserDefaults standardUserDefaults] boolForKey:PEShowHeaderLine] == YES)
    {
        [context printFormat:@"1 setlinewidth 30 %g moveto %g %g lineto stroke\n", borderSize.height - 33.0, borderSize.width - 30.0, borderSize.height - 33.0];
    }

    //if ( [[NSUserDefaults standardUserDefaults] boolForKey:PEShowFooterLine] == YES)
    {
        [context printFormat:@"1 setlinewidth 30 40 moveto %g 40 lineto stroke\n", borderSize.width - 30.0];
    }

    [context printFormat:@"/Helvetica findfont\n"];
    [context printFormat:@"10 scalefont\n"];
    [context printFormat:@"setfont\n"];

    // top left
    string = [NSString stringWithFormat:@"%@", NSUserName()];;
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = @"DATopLeft";
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %g moveto\n", 30.0, borderSize.height - 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }

    // top right
    string = nil;
    if (([self respondsToSelector:@selector(delegate)] == YES) && ([self delegate] != nil))
    {
        if ( [[self delegate] respondsToSelector:@selector(file)] == YES )
            string = [[[self delegate] file] stringByStandardizingPath];
    }

	if ( string == nil )
		string = [[self window] representedFilename];

	if (string != nil)
	{
		// convert the path to PS friendly version.
		// PS interperts '\' slashes, so they must be converted to either '\\' or '/', of course I have to also escape them with NSString so '\' becomes '\\' and '\\' -> '\\\\' (yikes)
        string = [[string componentsSeparatedByString:@"\\"] componentsJoinedByString:@"\\\\"];
	}
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = @"DATopRight";
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %@ stringwidth pop sub\n", (borderSize.width - 30.0), owDPSfunction];
        [context printFormat:@"%g moveto\n", borderSize.height - 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }


    /*
    // top middle
    string = [self stringForPosition:TopMiddle];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"DA%@", TopMiddle];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %@ stringwidth pop 2.0 div sub\n", (borderSize.width/2.0), owDPSfunction];
        [context printFormat:@"%g moveto\n", borderSize.height - 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }
*/
    // bottom left
    string = [[NSCalendarDate calendarDate] descriptionWithCalendarFormat:@"%d-%b-%y %I:%M %p %Z"];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"DABottomLeft"];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %g moveto\n", 30.0, 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }
    
/*
    // bottom middle
    string = [self stringForPosition:BottomMiddle];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = [NSString stringWithFormat:@"DA%@", BottomMiddle];
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %@ stringwidth pop 2.0 div sub\n", (borderSize.width/2.0), owDPSfunction];
        [context printFormat:@"%g moveto\n", 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }

     */

    // bottom right
    string = [NSString stringWithFormat:@"Page %d", [[NSPrintOperation currentOperation] currentPage]];
    if ( string && ([string length] > 0));
    {
        NSString *owDPSfunction = @"DABottomLeft";
        [context printFormat:@"/%@ (%@) def\n", owDPSfunction, string];
        [context printFormat:@"%g %@ stringwidth pop sub\n", (borderSize.width - 30.0), owDPSfunction];
        [context printFormat:@"%g moveto\n", 30.0];
        [context printFormat:@"%@ show\n", owDPSfunction];
    }
}

@end
