/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */

#import "RemoteAppWillTerminate_Protocol.h"

@protocol RemoteApp

	/* Allows apps to lock control. This limits access from other clients 
	 * until unlock is issued. If this returns NO, someone else has control.
	 */ 
- (BOOL)doLock;

	/* Removes lock, see above.
	 */
- (void)unlock;

	/* Returns YES if in Demo mode
	 */
- (BOOL)inDemoMode;

	/* Displays NXAlertPanel from remoteApp
	 */
- (int)alertPanel:(NSString *)title 
	:(NSString *)msg 
	:(NSString *)defaultButton
	:(NSString *)alternateButton
	:(NSString *)otherButton;
	
	/* Returns current API Version string
 	 */
- (NSString *)apiVersionString;

	/* Returns a list of document names.  Each item in the list corresponds to 
	 * an open document. Can be used to load NXBrowsers.
	 *
	 * must free memory returned by this call
	 */
- (NSArray *)listOfDocuments;

	/* Make WriteUp the active app.
	 */
- (void)makeActive:(BOOL)activate;

	/* Returns the number of open documents.
	 */
- (int)numberOfDocuments;

	/* Returns the document name for the idx'th item from the list of documents 
	 */
- (NSString *)documentAtIndex:(int)idx;

	/* Register for appWillTerminate
	 */
- (void)registerForTerminate:(id <RemoteAppWillTerminate>)object;

	/* Returns template directory
	 */
- (NSString *)templateDirectory;

/* 
 * Drops the memory for every object (documents and flows) the remote may have  
 * received. Called when user application terminates.
 */
- (void)freeResources;

- (NSString *)hostname;

@end

