/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */

@class TableDefinition;
#import "ParagraphAccess_Protocol.h"

/* A flow consists of a list of Paragraph objects which in turn, 
 * contain lists of Word objects.
 */

@protocol FlowAccess

	/* Simulates keyboard entry
	 */
- (void)addByte:(int)aKey;

	/* Adds a table
	 */
- (TableDefinition *)addTableWithJustification:(int)alignment 
	rows:(int)nrows cols:(int)ncols cellWidth:(float)aWidth;

- (void)appendString:(NSString *)aString;

	/* Returns the current paragraph.
	 */
- (id <ParagraphAccess>)currentParagraph;

	/* Returns the index of the current paragraph in the current flow.
	 */
- (int)currentParagraphIndex;

	/* Inserts graphic inline at the current insertion point.
	 */
- (void)insertInlineGraphic:(NSString *)filename named:(NSString *)name;

	/* Inserts graphic inline at the current insertion point. Set size to 
	 * newWidth and newHeight.
	 */
- (void)insertInlineGraphic:(NSString *)filename named:(NSString *)name
	width:(float)newWidth height:(float)newHeight;

	/* Inserts graphic inline at the current insertion point. Set scale to 
	 * scaleWidth and scaleHeight. (1.0 equals 100%)
	 */
- (void)insertInlineGraphic:(NSString *)filename named:(NSString *)name
	scaleWidth:(float)scaleWidth scaleHeight:(float)scaleHeight;

	/* Frees the resource for the flow
	 */
- (void)freeResource;

	/* number of Paragraphs in a flow.
	 */
- (void)recomputeAllDirtyParagraphs;
- (int)paragraphCount;

	/* Returns the paragraph at idx in the list.
	 */
- (id <ParagraphAccess>)paragraphAtIndex:(int)idx;

	/* Selects the current paragraph, with a paragraph selection, similiar to a 
	 * triple click.
	 */
- (void)selectCurrentParagraph;

	/* Selects the current paragraph contents, similiar to a 
	 * single click, drag and release.
	 */
- (void)selectCurrentParagraphContents;

	/* Selects the a paragraph, with a paragraph selection, similiar to a 
	 * triple click.
	 */
- (void)selectParagraph:(id <ParagraphAccess>)aParagraph;

	/* Sets the insertion point to the c'th character in the w'th word in 
	 * the p'th paragraph in the document.
	 */
- (void)setInsertPoint:(int )p :(int )w :(int )c;

	/* Returns the name given to the style object for the paragraph at idx in 
	 * the list.
	 */
- (NSString *)styleOfParagraph:(int)idx;

@end

