/* DONE */
/*
Copyright (c) 1998 by Sean Luke (hereafter referred to as "the Author")
seanl@cs.umd.edu     http://www.cs.umd.edu/users/seanl/

Permission to use, copy, modify, and distribute the source code and
related materials of this software for any purpose and without fee is
hereby granted, provided the Author's name shall not be used in
advertising or publicity pertaining to this material without the
specific, prior written permission of the Author, acknowledgement
of the author appears prominently in the distributed documentation
of any software application derived from this source code, and this
copyright notice appears in all derived source copies.  SEAN LUKE MAKES
NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS MATERIAL
FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES.

*/

/***********************************************************************
 ModuleProtocol.h
 Sean Luke

 ModuleProtocol is used by modules to communicate with the moduleController.
 Many of these methods are only here for backward compatibility with older
 modules; you should use only the methods listed in ModuleProtocol.rtf
 or ModuleProtocol.htmld.  See Resound's Help system for more information.
************************************************************************/


#import <AppKit/AppKit.h>
#import <SoundKit/SoundKit.h>

@protocol ModuleProtocol

/* SPECIAL PANELS 

	The following method brings up a common alert panel with OK and Cancel.
	For other panels, I suggest using NXRunAlertPanel().  This method is
	for backward-compatibility only.
*/


- (BOOL) runLongTimePanel;	/* Runs a standard panel saying something to the 
							   effect of "This operation will take a long
							   time to perform on this sound.  Proceed?"
							   Returns YES if the user pressed "Okay"
							   (wants to proceed), NO if the user pressed
							   "Cancel". */
								   



/* SOUND ACCESS METHODS 

	The following methods return the current sound, soundview,
	or window.  If no sound's window is a key or main window, or
	some other problem has arisen that prevents the module from
	accessing a sound and soundview, these methods return NULL.
*/


- currentSound;				/* Returns the Current Sound, NULL if none */

- currentSoundView;			/* Returns the Current SoundView, NULL if none */

- currentWindow;			/* Returns the Current Window, NULL if none */
			
	
- currentPlayingSound;		/* Returns Current Playing Sound, or NULL */

- currentPlayingSoundView;	/* Returns Current Playing SoundView, or NULL */

- currentPlayingWindow;		/* Returns Current Playing Window, or NULL */
	
			
/* SOUND MODIFICATION METHODS 

	The following methods will replace a sound in a soundview,
	or generate a new soundview, sound, and window.
*/
			
			
			
								   
- brandNewSound: thisSound;		/* Tells the program to create a new soundview
								   for a brand new sound generated by the 
								   module.*/	   
- newSound: thisSound for
	: thisSoundView;			/* Informs the program that a SoundView
								   (typically the current SoundView) has been 
								   given a new associated sound. Also calls 
								   SoundChanged.  This procedure does NOT
								   actually put the sound in the new soundview,
								   but merely informs the program.  You must 
								   set the soundview's new sound yourself. */


/* SOUND UPDATE METHODS

	The following methods inform Resound that various aspects
	of a sound have changed.
*/


- soundTouched;					/* compatibility update method:  same as
								   soundChanged */
- soundChanged;					/* Informs the program that a sound has been 
								   changed in some way or edited.  This sets 
								   the X on the top right of the window to a 
								   broken X, and makes the program pull up a 
								   "Save Before Close?" panel when the file 
								   is closed, or when the program quits.  */
					   
- selectionChanged;				/* Informs the program that the selection of a
								   soundview has been changed. (Through a 
								   "Select All", for instance. Requires 
								   selection to be for Current Sound.  */
								   								   
- infoChanged;					/* Informs the program that any sound 
								   information has been changed (sampling rate,
								   number of samples, sample size--8 or 16 
								   bits, fragmentation, info string, etc.
								   Now only here for backward-compatibility;
								   this method just calls soundChanged.  */

- fragmentationChanged;			/* Informs the program that the sound has
								   become fragmented or unfragmented. */

- zoomChanged;					/* Informs the program that the reduction 
								   factor for a soundview has been changed. 
								   Requires zoom to be for Current Sound. */


/*	PLAY/RECORD METHODS

	These methods determine if a sound is playing or recording.
	This sound does NOT have to be the current sound.  If your
	module modifies a sound, stop recording and playing first.
	If your module just examines from a sound, you should stop
	recording, though playing is probably insignificant.
*/				
				   
				   
- stop;							/* Stops whatever sound is playing 
								   or recording */
								   
- (BOOL) isPlaying;				/* Returns TRUE if a sound is playing */

- (BOOL) isRecording;			/* Returns TRUE if a sound is recording */


/* WINDOW METHODS

	In general, it's best if your module doesn't use Windows--use Panels
	instead.  But in the off chance that you need to use windows, Resound 
	needs to know so it can set the CurrentSound, CurrentSoundView,
	and CurrentWindow to NULL, and update its inspector accordingly.
	When a window of yours becomes main, please call the following:

*/

- moduleWindowDidBecomeMain;





/* PASTEBOARD BUG FIXES -- DO NOT USE THESE ANY MORE!  THEY'RE INAPPROPRIATE
   FOR RHAPSODY OR OPENSTEP */


- (BOOL) isOwner:this_sound_or_soundview;
                                                        /* Returns YES if this_sound_or_soundview
                                                           is the owner of the pasteboard or its
                                                           internal sound is the owner of the pasteboard.
    NO LONGER USED IN OPENSTEP*/

- (BOOL) stillExists;   	/* Returns YES if pasteboard owner is NULL or
                                still a valid sound, soundview, or
                                  sound window in Resound's sound
                                   table.  This is useful to determine
                                   if the owner of a pboard hasn't been
                                 freed before you try to paste data
    into a sound or soundview. NO LONGER USED IN OPENSTEP*/

- invalidatePasteboard;					/* Invalidates the pasteboard.
                                                                NO LONGER USED IN OPENSTEP */


/* GETTING NEW WINDOWS */

- (void)newWindow:(NSWindow**) theWindowPointer:(NSScrollView**) theScrollViewPointer:(SoundView**)theSoundViewPointer;




@end