//
// $Id$
//

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

//----------------------------------------------------------------------
// Debug tracing
//----------------------------------------------------------------------

#define DSTART NSLog (@"%@(%lx)[%d] - %@\n", NSStringFromClass ([self class]), self, [self retainCount], NSStringFromSelector (_cmd))
#define DEND NSLog (@"%@(%lx)[%d] ~ %@\n", NSStringFromClass ([self class]), self, [self retainCount],  NSStringFromSelector (_cmd))

//----------------------------------------------------------------------
// Simple exception handler
//----------------------------------------------------------------------

#define EHAND NSRunAlertPanel ([localException name], @"%@ - %@\n %@", @"OK", nil, nil,\
                               NSStringFromClass ([self class]), NSStringFromSelector (_cmd), [localException reason])
#define ELOG NSLog (@"%@ in %@ - %@, reason: %@", [localException name],\
                    NSStringFromClass ([self class]), NSStringFromSelector (_cmd), [localException reason])


//----------------------------------------------------------------------
// This releases the object if it is non-nil, and then makes
// sure the variable is nil afterward so that we don't have
// references to non-existant objects
//----------------------------------------------------------------------

#define SNRelease(name) \
    if (name != nil) \
    { \
        [name release]; \
        name = nil; \
    }


//----------------------------------------------------------------------
// Borrowed from Omni
//----------------------------------------------------------------------

#define NSSTRINGIFY(name) @ ## '"' ## name ## '"'
#define DEFINE_NSSTRING(name) NSString *name = NSSTRINGIFY(name)

//----------------------------------------------------------------------
// Other
//----------------------------------------------------------------------

#define RCSID(str) \
    static inline const char *rcsid (void) \
    { \
        return str " cc:" __DATE__ " " __TIME__; \
    }

#define SNBoolFromString(str) (([str isEqual:@"YES"]==YES)?YES:NO)
#define NSStringFromBool(flag) ((flag==YES)?@"YES":@"NO")

#define SNLog(object) NSLog(@"%@: %@",  NSSTRINGIFY(object), object)
#define SNLogPoint(point) NSLog(@"%@: %@", NSSTRINGIFY(point), NSStringFromPoint(point))
#define SNLogRect(rect) NSLog(@"%@: %@", NSSTRINGIFY(rect), NSStringFromRect(rect))
#define SNLogSize(size) NSLog(@"%@: %@", NSSTRINGIFY(size), NSStringFromSize(size))
#define SNLogBool(bool) NSLog(@"%@: %@", NSSTRINGIFY(bool), NSStringFromBool(bool))

#if 0
#define SNDebugDict(object) if (object != nil) [debugDictionary setObject:object forKey:NSSTRINGIFY(object)]
#endif

#define SNAddObjectToDebugDictionary(dict,object) if (object != nil) [dict setObject:object forKey:NSSTRINGIFY(object)]
#define SNAddBOOLToDebugDictionary(dict,bool) [dict setObject:(bool==YES)?@"YES":@"NO" forKey:NSSTRINGIFY(bool)]
