#import "../poker.h"

@implementation Preferences

+ (id)sharedInstance {
   static id shared = nil;

   if (!shared) {
       shared = [[self allocWithZone:NULL] init];
   }
   return shared;
}

- (id)init {
   self = [self initWithWindowNibName:NSStringFromClass([self class])];
   if (self) {
       [self setWindowFrameAutosaveName:NSStringFromClass([self class])];
   }
   return self;
}


- (IBAction)changeUserNameAction:(id)sender {
    NSString *user = [userNameField stringValue];
    NSString *oldUserName = [[NSApp delegate] userName];
    if (user && ![user isEqualToString:@""] && ![oldUserName isEqualToString:user]) {
        [[NSUserDefaults standardUserDefaults] setObject:user forKey:@"Name"];
        [[NSUserDefaults standardUserDefaults] synchronize];
   	[[NSApp delegate] makeConnectionAndJoinTable:self];
    }
    [[self window] orderOut:self];
}

- (void)showWindow:(id)sender {
   [super showWindow:sender];
   [userNameField setStringValue:[[NSApp delegate] userName]];
}
@end
