#import "PotManager.h"

@implementation PotManager

#define COIN_STEP   6.0
#define MAX_COINS   40

- (NSImage *)imageWithNumberCoins:(int)numCoins
{
   NSRect r =  [potImage frame];
   NSImage *scratchImage = [[[NSImage allocWithZone:NULL] initWithSize:r.size]autorelease];
   NSImage *coin = [NSImage imageNamed:@"Coin"];
   unsigned i, col = 0;
   float cWidth = [coin size].width;

// lock focus on the destination image:
   [scratchImage lockFocus];

// set the color to transparent and fill it:
   [[NSColor clearColor] set];
   NSRectFill(NSMakeRect(0.0,0.0,r.size.width,r.size.height));

// step through and make that many coins:
   for (i = 0; i < numCoins; i++) {
        NSPoint origin = NSMakePoint(col*cWidth,(i - col * MAX_COINS) *COIN_STEP);
        [coin compositeToPoint:origin operation:NSCompositeSourceOver];
        if (i == MAX_COINS) col = 1;
   }

// NEVER forget to unlock focus!
   [scratchImage unlockFocus];
   return scratchImage;
}

- (void)updatePotAmount:(int)amount
{
    pot = amount;
    [potImage setImage:[self imageWithNumberCoins:rint(amount/100.0)]];
    [potField setStringValue:[NSString stringWithFormat:@"$ %d",amount]];
}

- (int)pot {
   return pot;
}

@end
