
@class Card, PokerTable,HoldEmHighHoleHand;

@interface Player : NSObject
{
    NSString * playerName;
    int stack;		// the money
    HoldEmHighHoleHand *holeHand;
    BOOL onVacation;
    BOOL hasFolded;
    BOOL isMe;
    int row;			// ui matrix location of player
    int column;			// the column of player
    PokerTable *table;
}

- (id)initWithName:(NSString *)name pokerTable:(PokerTable *)tourney;
- (NSString *)buttonTitle; // a formatted string with player name and amount and status
- (NSString *)playerName;

// call at new game:
- (void)getNewHand;
- (HoldEmHighHoleHand *)holeHand;

- (BOOL)isMe;
- (void)setIsMe:(BOOL)isOwner;

- (BOOL)onVacation;
- (void)setOnVacation:(BOOL)isOwner;

- (void)fold;
- (BOOL)hasFolded;

- (void)setStackAmount:(int)amount;
- (int)stackAmount;

- (int)column;
- (void)setColumn:(int)aCol;

- (int)row;
- (void)setRow:(int)aRow;

@end
