#import <AppKit/AppKit.h>
@class PokerTable;

@interface IRCTask : NSObject
{
  NSTextView *text;
  id owner;
  NSTask *aTask;
  NSPipe *to_irc;
  NSPipe *from_irc;
  PokerTable *pokerTable;
}
- (void)makeIRCConnection:(PokerTable *)table;
+ (id)sharedIRCTask;
- (void)pushStringOverWire:(const char *)buf;

- (void)returnFromVacation;
- (void)goOnVacation;
- (void)bet:(int)amount;
- (void)minBet;
- (void)pushAllIn;
- (void)call;
- (void)fold;
- (void)halfPot;
- (int)pot;
- (void)leaveTable;
- (void)joinTable;

@end
