/// ftp://www.ardi.com/private/machack/
#import "Card.h"

@implementation Card

- initSuit:(Suit)aSuit rank:(Rank)aRank {
    self = [super init];
    suit = aSuit;
    rank = aRank;
    return self;
}

+ cardWithSuit:(Suit)aSuit rank:(Rank)aRank {
   return [[[Card allocWithZone:NULL] initSuit:aSuit rank:aRank]autorelease];
}

+ (NSImage *)imageForCard:(Card *)card {
    return [NSImage imageNamed:[NSString stringWithFormat:@"%d",[card rank]*4 + [card suit]]];
}

- (Suit)suit {
    return suit;
}

- (int)rank {
   return rank;
}

- (NSImage *)image {
   return [Card imageForCard:self];
}

- (id)copyWithZone:(NSZone *)zone {
    return [[Card allocWithZone:zone] initSuit:suit rank:rank];
}

@end