/* PDPopOverMailProcessor.m created by jfosback on Wed 04-Feb-1998 */

#import "PDPopOverMailProcessor.h"
#import "PDExternalComposition.h"

#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

@implementation PDPopOverMailProcessor

- (void)actuallyOpenComposeWindow
{
	NSConnection *connection = nil;
	NSString *portName = @"MailClientInterface";
	id <PDExternalComposition> remoteComposer = nil;

	connection = [NSConnection connectionWithRegisteredName:portName
					host:nil];
	if (!connection)
	{
		portName = @"PopOver";
		connection = [NSConnection connectionWithRegisteredName:portName
					host:nil];
	}
        remoteComposer = (id <PDExternalComposition>) [connection rootProxy];
	if (!remoteComposer)
	{
		[NSException raise:NSInternalInconsistencyException
			format:@"-[%@ %@]: Unable to establish connection to server: %@",
				NSStringFromClass([self class]),
				NSStringFromSelector(_cmd),
				portName];
	}
	[remoteComposer composeMessageTo:
            [parameterDictionary objectForKey: OWMailToProcessorToParameterKey]
		subject:
            [parameterDictionary objectForKey: OWMailToProcessorSubjectParameterKey]
		body:
            [parameterDictionary objectForKey: OWMailToProcessorBodyParameterKey]
            ];

	return;
}

- (void)mailInMainThread
{
	NSString *mailer = @"PopOver";

	if (![[NSWorkspace sharedWorkspace] launchApplication:mailer])
	{
		[NSException raise:NSInternalInconsistencyException
			format:@"-[%@ %@]: Unable to launch mailer: %@",
				NSStringFromClass([self class]),
				NSStringFromSelector(_cmd),
				mailer];
	}
	[self performSelector:@selector(actuallyOpenComposeWindow)
		withObject:nil];
	return;
}

- (void)deliver
{
	[self mainThreadPerformSelector:@selector(mailInMainThread)];
}

@end
