/*
 * PuzzleActions.m
 * 5/3/99 Mike Trent
 *
 * A little object to manage access to an ANSI C array of NSRects. This gives
 * my ANSI C array garbage collection and range protection.
 */

#import "PuzzleRectArray.h"

@implementation PuzzleRectArray

- (id)initWithCount:(int)count
{
    self = [super init];

    if (self) {
        _array = NSZoneMalloc(NSDefaultMallocZone(), sizeof(NSRect) * count);
        _count = count;
    }

    return self;
}

- (void)dealloc
{
    if (_array) NSZoneFree(NSDefaultMallocZone(), _array);
    [super dealloc];
}

- (NSRect)rectAtIndex:(int)index
{
    if (index < 0 || index >= _count) {
        NSLog(@"PuzzleRectArray rectAtIndex called with bad index.");
        return NSMakeRect(0,0,0,0);
    }
    return _array[index];
}

- (void)setRect:(NSRect)rect atIndex:(int)index
{
    if (index < 0 || index >= _count) {
        NSLog(@"PuzzleRectArray setRect:atIndex: called with bad index.");
    } else {
        _array[index] = rect;
    }
}

- (void)swapIndex:(int)a withIndex:(int)b
{
    if (a < 0 || a >= _count || b < 0 || b >= _count) {
        NSLog(@"PuzzleRectArray swapIndex:withIndex: called with bad index.");
    } else {
        NSRect r = _array[a];
        _array[a] = _array[b];
        _array[b] = r;
    }
}

@end
