/* PuzzleActions.h created by mtrent on Sat 01-May-1999 */

#import <AppKit/AppKit.h>
#import "PuzzleRectArray.h"

struct State {
    NSImage		*screen;	// screenshot
    PuzzleRectArray	*screenRects;	// screenshot rects
    NSSize  		tileArea;	// area dimensions measured in tiles
    NSSize  		tileSize;	// size of a single tile
    NSPoint		deadTile;	// tile # representing dead space.
    NSPoint		liveTile;	// tile # for our tile of interest.
};
typedef struct State State;

@interface PuzzleAction : NSObject
{
    State _state;
    
    NSDate *_startDate;
    NSTimeInterval _endInterval;

    NSMutableArray *_actions;
    BOOL _expired;
}
+ (float)speed;
+ (void)setSpeed:(float)speed;
+ (float)playSounds;
+ (void)setPlaySounds:(BOOL)sound;
- (id)initWithState:(State*)state;
- (void)oneStep;
- (BOOL)expired;
- (id)newAction;
@end

@interface PuzzleStartAction : PuzzleAction
{
    BOOL _once;
}
- (id)initWithImage:(NSImage*)image tileWidth:(float)width;
- (void)makeTileList:(NSImage*)screen tileSize:(float)tileSize;
@end
