#import <Foundation/NSString.h>
#import "IKIconPath.h"
#import "IKDependency.h"

@interface NSObject(IKShelfAnnouncements)
+ (unsigned int)shelf:sender willDrag:objectToPaste from:(id <NSDraggingInfo>) source;
+ shelf: sender  dragWillEnter:(id <NSDraggingInfo>) source;
+ shelf: sender  dragWillExit:(id <NSDraggingInfo>) source;
+ shelf: sender  dragWillComplete:(id <NSDraggingInfo>) source;
@end

@interface IKShelf:IKIconPath 
<IKDependency>
{
		id		 users,
				 objectToPaste;
	
		NSString *classToHold;
		BOOL	 dynamic,
				 lastIsEmptyContainer;
}
+ (void)initialize;
- (NSString *) inspectorClassName;
- initWithFrame:(NSRect)frameRect;
- initWithFrame:(NSRect)frameRect;
- (void)dealloc;
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;
- (void)addUser: who;
- (void)addListener: who;
- (void)removeUser: who;
- (void)removeListener: who;
- (BOOL) isDynamic;
- (NSString *) classToHold;
- setDynamic: (BOOL) flag;
- (void)setClassToHold: (NSString *) name;
- delegate;
- (void)setFrameSize:(NSSize)_newSize;
- fillWithCells;
- sizeCellsToFit;
- (void)mouseDown:(NSEvent *)event;
- (unsigned int) draggingOperation: (id <NSDraggingInfo>) sender;
- (unsigned int) draggingEntered: (id <NSDraggingInfo>) sender;
- (void)draggingExited:(id <NSDraggingInfo>)sender;
- (unsigned int) cellEntered: (id <NSDraggingInfo>) sender;
- (unsigned int) cellUpdated: (id <NSDraggingInfo>) sender;
- (void)cellExited: (id <NSDraggingInfo>) sender;
- (BOOL) prepareForDragOperation: (id <NSDraggingInfo>) sender;
- (BOOL) performDragOperation: (id <NSDraggingInfo>) sender;
- (void)concludeDragOperation:(id <NSDraggingInfo>)sender;

@end

