#import <AppKit/NSMatrix.h>
#import "IKCell.h"

@interface IKIconPath:NSMatrix
{
	IKCell	*current;
	IKCell	*last;
        BOOL    draggingEntered;
}

- initWithFrame:(NSRect)frameRect;
- initWithFrame:(NSRect)frameRect mode:(int)aMode prototype:aCell numberOfRows:(int)rows numberOfColumns:(int)cols;
- initWithFrame:(NSRect)frameRect mode:(int)aMode cellClass:class numberOfRows:(int)rows numberOfColumns:(int)cols;
- (void)mouseDown:(NSEvent *)event;
- (BOOL) shouldDelayWindowOrderingForEvent:(NSEvent *)theEvent; ;
- editCell:theCell;
- editCellAt:(int) row  :(int) col;
- (void)endEditing;
- (BOOL)abortEditing;
- (void)resetCursorRects;
- (void)drawCellInside:(NSCell *)theCell;
- (NSArray *)selectedCells;
- (void)setCellSize:(NSSize)size;
- (void)setIntercellSpacing:(NSSize)size;
- (void)setFrameSize:(NSSize)_newSize;
- cellWithDelegate:delegate;
- objectInColumn:(int) n;
- (NSString *)stringValue;
- (unsigned int) draggingSourceOperationMaskForLocal:(BOOL) isLocal;
- (unsigned int) draggingEntered:(id <NSDraggingInfo>) sender;
- (unsigned int) draggingUpdated:(id <NSDraggingInfo>) sender;
- (void)draggingExited:(id <NSDraggingInfo>)sender;
- (BOOL)enteredNewCell:(NSPoint) where;
- (unsigned int) cellEntered:(id <NSDraggingInfo>) sender;
- (unsigned int) cellUpdated:(id <NSDraggingInfo>) sender;
- (void)cellExited:(id <NSDraggingInfo>) sender;
- (BOOL) prepareForDragOperation:(id <NSDraggingInfo>) sender;
- (BOOL) performDragOperation:(id <NSDraggingInfo>) sender;
- (void)concludeDragOperation:(id <NSDraggingInfo>)sender;

@end

