#import <AppKit/NSBrowser.h>

@protocol IKBrowserDelegate
- (void)browser:(NSBrowser *)sender createRowsForColumn:(int)column inMatrix:(NSMatrix *)matrix;
- browser: sender  setColumnIcon: cell  for: (int) column;
@end

@interface NSObject (IKBrowserDelegateOptionalMethods)
- browser:sender emptyMatrix: matrix  inColumn: (int) column;
- browser:sender removeColumnIcon: cell  for: (int) column;
- browserWillFinishChange:sender;
- browserDidChange:sender;
- browserClicked:sender;
- browserDoubleClicked:sender;
@end


@interface IKBrowser: NSBrowser
{
    id		iconPath;
	id		scrollView;
	
	BOOL	autoSynchronize;
	
	SEL		scroll;
}

- initWithFrame:(NSRect)frameRect;
- (NSString *) inspectorClassName;
- (void)removeAllFolders;
- iconPath;
- scrollView;
- (void)setIconPath: theIconPath;
- (void)setScrollView: theScrollView;
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;
- (void)setFrameSize:(NSSize)_newSize;
- (void)sizeCells;
- (void)synchronizePath;
- (void)setAutoSynchronize: (BOOL) flag;
- (void)newSelection;
- (void)beginUpdate;
- (void)endUpdate;
- (void)addColumn;
- (void)setLastColumn:(int)n;
- (void)setReusesColumns:(BOOL)flag;
- (BOOL)setPath:(NSString *)path;
- takePathFrom:sender;
- resetColumn: (int) n  usingPath: (NSString *) path;
- scrolling:sender;
- iconSelected:sender;
- (void)doClick:(id)sender;
- (void)doDoubleClick:(id)sender;
- (void)keyDown:(NSEvent *)theEvent;
- (void)selectAll:(id)sender;
- (NSArray *)selectionInColumn: (int) column;

@end

