/* Expense.h
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed
 * or implied, as to its fitness for any particular use.
 */

#import <Foundation/Foundation.h>

extern NSString *defaultNewCategory;

@interface Expense : NSObject
{
    NSString *category;
    NSCalendarDate *date;
    NSNumber *amount;
    BOOL billable;
}

- (id)init;
- (void)dealloc;

// Attributes
- (void)setCategory:(NSString *)value;
- (NSString *)category;
- (void)setDate:(NSCalendarDate *)value;
- (NSCalendarDate *)date;
- (void)setAmount:(NSNumber *)value;
- (NSNumber *)amount;
- (BOOL)isBillable;
- (void)setIsBillable:(BOOL)isBillable;

// Archiving
- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)coder;

@end
