/* Logger.h
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed
 * or implied, as to its fitness for any particular use.
 */

#import <AppKit/AppKit.h>

@interface Logger : NSObject
{
    id panel;
    id textView;
    id enabledCheck;
    id timeStampingCheck;
    id autoScrollingCheck;

    // state 
    BOOL isEnabled;
    BOOL isAutoScrolling;
    BOOL isTimeStamping;
    BOOL appendWithNewline;

    NSFont *font;
}

- (id)init;

- (void)awakeFromNib;

// Logger Interface
+ (void)log:(NSString *)string;
- (void)log:(NSString *)string;
- (void)clear;
- (void)setIsEnabled:(BOOL)state;
- (BOOL)isEnabled;
- (void)setIsTimeStamping:(BOOL)state;
- (BOOL)isTimeStamping;
- (void)timeStamp;
- (void)setIsAutoScrolling:(BOOL)state;
- (BOOL)isAutoScrolling;
- (BOOL)appendWithNewline;
- (void)setAppendWithNewline:(BOOL)state;
- (NSString *)title;
- (void)setTitle:(NSString *)string;

// target/action
- (void)show:(id)sender;
- (void)clear:(id)sender;
- (void)save:(id)sender;
- (void)load:(id)sender;
- (void)changeIsEnabled:(id)sender;
- (void)changeIsTimeStamping:(id)sender;
- (void)changeIsAutoScrolling:(id)sender;

@end
