/* AppController.h
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed
 * or implied, as to its fitness for any particular use.
 */

#import <AppKit/AppKit.h>

@interface AppController : NSObject
{
    NSMutableArray	*documents;
    id aboutPanel;
    id inspector;
    id prefController;
    id logger;
}

- (id)init;
- (void)dealloc;
- (void)registerDocument:(id)doc;
- (void)unregisterDocument:(id)doc;
- (id)prefController;
- (id)logger;

// target/action
- (void)showAboutPanel:(id)sender;
- (void)showInspector:(id)sender;
- (void)showLogger:(id)sender;
- (void)newDocument:(id)sender;
- (BOOL)openFile:(NSString *)path;
- (void)openDocument:(id)sender;
- (void)saveAll:(id)sender;


// NSApplication delegation/notification
- (void)applicationDidFinishLaunching:(NSNotification *)aNotification;
- (BOOL)applicationShouldTerminate:(id)sender;

// Menu updating/validation
- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem;

@end
