#import "Sort.h"
#import "AppController.h"

// Our own copy of the string to avoid making SortingDataSource.h a
// project header (which would work too)
static NSString *sortByDefaultName = @"sortByColumn";
static int sortByNoneTag = 3;

@implementation Sort

- (NSArray *)titles
{
    NSArray *cells = [radio cells];
    NSEnumerator *cellEnum = [cells objectEnumerator];
    NSMutableArray *titles = [NSMutableArray array];
    id	cell;
    while (cell = [cellEnum nextObject])
    {
        [titles addObject:[cell title]];
    }
    return titles;	// autoreleased
}

- (void)awakeFromNib
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSArray *titles = [self titles];
    int tag = [titles indexOfObject:[defaults stringForKey:sortByDefaultName]];
    if (tag == NSNotFound) tag = sortByNoneTag;	// None
    [radio selectCellWithTag:tag];
    [super awakeFromNib];
}

- (void)change:(id)sender
{
    NSString *title = [[radio selectedCell] title];
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

    [defaults setObject:title forKey:sortByDefaultName];
    [defaults synchronize];
}

@end
