#import "Startup.h"

static NSString *defaultName = @"showInspector";

@implementation Startup

- (void)awakeFromNib
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [check setState:[defaults boolForKey:defaultName]];
    [super awakeFromNib];
}

- (void)change:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [defaults setBool:[sender state] forKey:defaultName];
    // Save to disk and broadcast change notification
    [defaults synchronize];
}

@end
