// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/SGML.subproj/OWSGMLDTD.h,v 1.4 1998/12/08 04:06:13 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OFTrie;
@class OWContentType, OWSGMLTagType;
@class NSArray;

@interface OWSGMLDTD : OFObject
{
    OFTrie *tagTrie;
    OWContentType *sourceType;
    OWContentType *destinationType;
    unsigned int tagCount;
}

+ (OWSGMLDTD *)dtdForSourceContentType:(OWContentType *)aSourceType;
+ (NSArray *)allDTDs;

- initWithSourceType:(OWContentType *)aSource destinationType:(OWContentType *)aDestination;

- (OFTrie *)tagTrie;
- (OWContentType *)sourceType;
- (OWContentType *)destinationType;
- (unsigned int)tagCount;
- (OWSGMLTagType *)tagTypeNamed:(NSString *)aName;
- (BOOL)hasTagTypeNamed:(NSString *)aName;

@end
