// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/SGML.subproj/OWHTMLToSGMLObjects.h,v 1.4 1998/12/08 04:06:11 kc Exp $

#import "OWDataStreamProcessor.h"

@class OFTrie;
@class OWDataStreamCursor, OWDataStreamScanner, OWObjectStream, OWSGMLDTD;

#import "OWStringDecoderProtocol.h"

@interface OWHTMLToSGMLObjects : OWDataStreamProcessor
{
    OWObjectStream *objectStream;
    OWDataStreamScanner *scanner;
    OFTrie *tagTrie;
}

+ (id <OWStringDecoder>)stringDecoder;
+ (NSStringEncoding)stringEncoding;
+ (void)setStringDecoderClass:(Class)aClass;
+ (Class)stringDecoderClass;

+ (BOOL)recognizesEntityNamed:(NSString *)entityName;
    // Returns YES if the named entity is known.

- initWithDataStreamCursor:(OWDataStreamCursor *)aDataStreamCursor forDTD:(OWSGMLDTD *)aDTD;
- initWithDataStreamCursor:(OWDataStreamCursor *)aDataStreamCursor;
- (OWObjectStream *)outputStream;

@end
