// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/Protocols.subproj/OWNNTPSession.h,v 1.7 1998/12/08 04:06:02 kc Exp $

#import "OWAbstractContent.h"

@class NSLock;
@class ONSocketStream;
@class OWAddress, OWContentType, OWPipeline, OWProcessor;

@interface OWNNTPSession : OWAbstractContent
{
    NSLock         *serverLock;
    ONSocketStream *controlSocketStream;
    NSString       *serverName;
    
    OWPipeline     *nonretainedPipeline;
    OWProcessor    *nonretainedProcessor;
    
    NSString       *lastReply;
    unsigned int    lastReplyIntValue;
    BOOL            abortFetch;
}

+ (NSString *) defaultNNTPServerHostName;

+ (OWContentType *) newsServerType;
+ (OWContentType *)newsgroupArticleType;
+ (OWContentType *)newsgroupHeaderListType;

+ (OWNNTPSession *) nntpSessionForAddress: (OWAddress *) address;

- initWithNewsServer: (NSString *) aServerName;

- (void)fetchForProcessor:(OWProcessor *)aProcessor inPipeline:(OWPipeline *)aPipeline;
- (void)abortFetch;

@end
