// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWHTTPProcessor.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWHTTPSessionQueue.h"
#import "OWURL.h"
#import "OWSourceProcessor.h"
#import "OWWebPipeline.h"
#import "OWDataStream.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWHTTPProcessor.m,v 1.29 1998/12/08 04:06:05 kc Exp $")

@implementation OWHTTPProcessor

// Class variables

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:[OWURL contentTypeForScheme:@"http"] toContentType:[OWSourceProcessor sourceContentType] cost:1.0];
}

- (void)startProcessingInHTTPSessionQueue:(OWHTTPSessionQueue *)aQueue;
{
    queue = aQueue;
    if ([queue queueProcessor:self])
        [super startProcessing];
}

- (void)handleSessionException:(NSException *)anException;
{
    if (status != OWProcessorAborting)
        [self handleProcessingException:anException];
    [self processAbort];
}

- (OWDataStream *)dataStream;
{
    return dataStream;
}

- (void)setDataStream:(OWDataStream *)aDataStream;
{
    dataStream = [aDataStream retain];
}

- (void)dealloc;
{
    [dataStream release];
    [super dealloc];
}

// OWProcessor subclass

- (void)startProcessing;
{
    [self startProcessingInHTTPSessionQueue:[OWHTTPSessionQueue httpSessionQueueForAddress:(OWAddress *)[pipeline lastContent]]];
}

- (void)processInThread;
{
    [queue runSession];
}

- (void)abortProcessing;
{
    [queue abortProcessingForProcessor:self];
    [dataStream dataAbort];
    [super abortProcessing];
}

@end

