/*
 File:       TitleLongevityController.m

 Contains:   Source code for the Controller of the "Title Longevity/Edited" window

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "TitleLongevityController.h"
#import "TitleLongevityView.h"
#import "ComicsObj.h"

@implementation TitleLongevityController

- (id)init
{
    if (self = [super init])
      {
        if (![NSBundle loadNibNamed:@"TitleLongevity" owner:self])
          {
            NSLog(@"Unable to load TitleLongevity.nib");
            [self release];
            return nil;
          }
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(comicsChanged:) name:ComicsDidChangeNotification object:nil];
      }
    return self;
}
- (void)comicsChanged:(NSNotification *)note
{
    [titleLongevity display];
    [nbSelTitles setIntValue:[titleLongevity nbSelTitles]];
}
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ComicsDidChangeNotification object:nil];
    [super dealloc];
}
- (void)awakeFromNib
{
#if debug
    NSLog(@"in TitleLongevityController:awakeFromNib");
#endif
    [[titleLongevity window] makeKeyAndOrderFront: nil];
    [nbSelTitles setIntValue:[titleLongevity nbSelTitles]];
#if debug
    NSLog(@"end of TitleLongevityController:awakeFromNib");
#endif
}

- (void)brandSelect:(id)sender
{
    [titleLongevity setBrand:[sender indexOfSelectedItem]];
    [titleLongevity display];
    [nbSelTitles setIntValue:[titleLongevity nbSelTitles]];
}

- (void)seriesSelect:(id)sender
{
    [titleLongevity setSeries:[sender indexOfSelectedItem]];
    [titleLongevity display];
    [nbSelTitles setIntValue:[titleLongevity nbSelTitles]];
}

- (void)editOrLong:(id)sender
{
    [titleLongevity setEditOrLong:[sender indexOfSelectedItem]];
    [titleLongevity display];
    [nbSelTitles setIntValue:[titleLongevity nbSelTitles]];
}

@end
