/*
    File:       JustTabItController.m

    Contains:	Sets up and maintains the tab view.

    Written by: Michelle Wyner

    Created:    October 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):
 		March 1998 - HI changes - DG  
		October 1997 - file first created.

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/


#import "JustTabItController.h"
#import "Hockey.h"
#import "HockeyData.h"

@implementation JustTabItController

- (void)awakeFromNib
{
    // When you add a new team, this sets the Ok button to work
    // when you press return.
    [addNewTeamWindow setDefaultButtonCell:[okButton cell]];

    // we're initially going to set up 2 tabs, with the 2 different views.
    [self setUpNewTab:@"RedWings" simpleTab:NO];
    [self setUpNewTab:@"Avalanche" simpleTab:YES];
    
    [[tabView window] makeKeyAndOrderFront:self];
}

- (void)tabView:(NSTabView *)tabView willSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
  // checking to see if the nib file for the tableview has been loaded.
    if (![[tabViewItem identifier] isLoaded]) {
        [tabViewItem setView:[[tabViewItem identifier] view]];
        [tabViewItem setInitialFirstResponder:[[tabViewItem identifier] 	initialFirstResponder]];
    }
}

- (void)addTab:(id)sender
{
    // Find out which view we're going to use since there's 2 possible ones.
    [self setUpNewTab:[newTeamTextField stringValue] simpleTab:(([gameDisplayButtons selectedTag] == 0) ? NO : YES)];
    [addNewTeamWindow close];
}

// since there are 2 possible views, the simpleTab variable lets us
// know which one we're using.

- (void)setUpNewTab:(NSString *)labelName simpleTab:(BOOL)flag
{
    HockeyData *newHockey = [[HockeyData alloc] initWithSimpleTab:flag];
    NSTabViewItem *tabViewItem = [[NSTabViewItem alloc] 			initWithIdentifier:newHockey];
    [tabViewItem setLabel:labelName];
    [tabView addTabViewItem:tabViewItem];
    [newHockey release];
    [tabView selectTabViewItem:tabViewItem];
}

- (void)removeTab:(id)sender
{

    [tabView removeTabViewItem:[tabView selectedTabViewItem]];  

    // the next line is needed because of a current bug in the NSTabView class.  This bug will be fixed in Premier.

    [[[tabView window] contentView] setNeedsDisplay:YES];  
}

- (void)cancelNewTeamAdd:(id)sender
{
  [addNewTeamWindow close];
}
@end
