/*
    File:       HockeyData.m

    Contains:	Methods that deal with the hockey object

    Written by: Michelle Wyner

    Created:    October 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):
		 March 1998 - HI changes - DG
                 October 1997 - file created.
 
    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/


#import "HockeyData.h"
#import "Hockey.h"

@implementation HockeyData

- (id)initWithSimpleTab:(BOOL)flag
{
    self=[super init];
    array = [[NSMutableArray alloc]init];
    [self generateTestData];
    _loaded=NO;
    _isSimple = flag;
    return self;
}

- (void)dealloc
{
    [view release];
    [array release];
    [super dealloc];
}

- (void)loadNibIfNeeded
{
    if (!_loaded) {
        _loaded = YES;
        [NSBundle loadNibNamed:@"HockeyInfo" owner:self];

        // loading the correct view, depending on if we want the full
        // schedule view or the single game one.
        if (_isSimple) {
            view = [[tempWindow2 contentView] retain];
        } else {
            view = [[tempWindow contentView] retain];
        }
        [view setAutoresizingMask:NSViewWidthSizable + NSViewHeightSizable];
        [tempWindow release];
        [tempWindow2 release];
    }
}

- (NSView *)view
{
    [self loadNibIfNeeded];
    return view;
}

- (NSView *)initialFirstResponder
{
    return view;
}

- (void)addRow:(id)sender
{
  Hockey *newHockey = [[Hockey alloc] init];
  int numInRow;
  
  //adding the new object to the end of the current Hockey's array.

  [array addObject:newHockey];
  [newHockey release];
  [transactionView reloadData];
  numInRow = [array count];
  numInRow--;
  [transactionView scrollRowToVisible:numInRow];
  [transactionView selectRow:numInRow byExtendingSelection:NO];
}

- (void)removeRow:(id)sender
{
  int index = [transactionView selectedRow];
  [array removeObjectAtIndex:index];

  // selecting the next row after the one we deleted.
  if (index == [array count])
    index = [array count] - 1;
  [transactionView selectRow:index byExtendingSelection:NO];
  
  [transactionView reloadData];
  
}

- (id)tableView:(NSTableView *)theTableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
  NSString *identifier;
  Hockey *hockey;
  SEL sel;
  
  hockey = [array objectAtIndex:row];
  identifier = [tableColumn identifier];
  sel = NSSelectorFromString(identifier);
  value = [hockey performSelector:sel];
  return value;
}

- (int)numberOfRowsInTableView:(NSTableView *)theTableView
{
  return [array count];
}

- (void)update
{
  [transactionView noteNumberOfRowsChanged];
  [transactionView reloadData];
}

- (void)generateTestData
{
  Hockey *tempHockey = [[Hockey alloc]init];
  
  [tempHockey setDate:[NSCalendarDate dateWithTimeIntervalSinceNow:60*60*24*1]];
  [tempHockey setAgainst:[NSString stringWithFormat:@"Wings"]];
  [tempHockey setScore:[NSString stringWithFormat:@"5-3"]];
  [tempHockey setOutcome:[NSString stringWithFormat:@"W"]];
  [array addObject:tempHockey];
  [self update];
  [tempHockey release];
}

- (void)tableView:(NSTableView *)tv setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row
{

  NSString *identifier;
  Hockey *hockey;
  SEL sel;
  
  hockey = [array objectAtIndex:row];
  identifier = [tableColumn identifier];

  sel = [self setAccessorFromIdentifier: identifier];
  [hockey performSelector:sel withObject:object];
}

- (SEL)setAccessorFromIdentifier:(NSString *)identifier
{
  NSString *string = [@"set" stringByAppendingString:
    [[identifier capitalizedString] stringByAppendingString:@":"]];
  
  return NSSelectorFromString(string);
}

- (BOOL)isLoaded
{
  return _loaded;
}


@end
