/* util.h
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Copyright (c) 1992, 1993, 1994, 1995, 1996, 1997 by Mike Gleason, NCEMRSoft.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, without modification,
 * are permitted.
 * 
 */

typedef int (*qsort_proc_t)(const void *, const void *);
typedef int (*bsearch_proc_t)(const void *, const void *);
typedef void (*sigproc_t)(int);
typedef volatile sigproc_t vsigproc_t;

#define STREQ(a,b) (strcmp(a,b) == 0)
#define STRNEQ(a,b,s) (strncmp(a,b,(size_t)(s)) == 0)

#ifndef ISTRCMP
#	ifdef HAVE_STRCASECMP
#		define ISTRCMP strcasecmp
#		define ISTRNCMP strncasecmp
#	else
#		define ISTRCMP strcmp
#		define ISTRNCMP strncmp
#	endif
#endif

#define ISTREQ(a,b) (ISTRCMP(a,b) == 0)
#define ISTRNEQ(a,b,s) (ISTRNCMP(a,b,(size_t)(s)) == 0)
#define YESNO(i) ((i == 0) ? "no" : "yes")
#define ONOFF(i) ((i == 0) ? "off" : "on")
#define TRUEFALSE(i) ((i == 0) ? "false" : "true")

#define kOurDirectoryName	".ncftp"

#define kPasswordMagic "*encoded*"
#define kPasswordMagicLen 9

/* util.c */
void ToBase64(void *, const void *, size_t, int);
void FromBase64(void *, const void *, size_t, int);
void OutOfMemory(void);
void *Realloc(void *, size_t);
char *GetCWD(char *, size_t);
void MyInetAddr(char *, size_t, char **, int);
struct hostent *GetHostEntry(const char *, struct in_addr *);
void CompressPath(char *, const char *, const size_t);
void PathCat(char *, const size_t, const char *, const char *);
void AbbrevStr(char *, const char *, size_t, int);
char *Path(char *, size_t, char *, char *);
char *OurDirectoryPath(char *, size_t, char *);
void InitOurDirectory(void);
void InitUserInfo(void);
int MayUseFirewall(const char *const);
int StrToBool(const char *const);
void AbsoluteToRelative(char *const, const size_t, const char *const, const char *const, const size_t);
int GetHostByName(char *const volatile, size_t, const char *const, int);
time_t UnDate(char *dstr);
