/* Util.h
 *
 * Copyright (c) 1996 Mike Gleason, NCEMRSoft.
 * All rights reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF NCEMRSOFT.
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 */

#ifndef _util_h_
#define _util_h_ 1

typedef char string[160], str16[16], str32[32], str64[64];
typedef char longstring[512];
typedef char pathname[512];

#ifndef PTRZERO
#	define PTRZERO(p,siz)  (void) memset(p, 0, (size_t) (siz))
#endif

#define ZERO(a)	PTRZERO(&(a), sizeof(a))
#define STREQ(a,b) (strcmp(a,b) == 0)
#define STRNEQ(a,b,s) (strncmp(a,b,(size_t)(s)) == 0)

#ifndef ISTRCMP
#	ifdef HAVE_STRCASECMP
#		define ISTRCMP strcasecmp
#		define ISTRNCMP strncasecmp
#	else
#		define ISTRCMP strcmp
#		define ISTRNCMP strncmp
#	endif
#endif

#define ISTREQ(a,b) (ISTRCMP(a,b) == 0)
#define ISTRNEQ(a,b,s) (ISTRNCMP(a,b,(size_t)(s)) == 0)

typedef int (*cmp_t)(const void *, const void *);
#define QSORT(base,n,s,cmp) \
	qsort(base, (size_t)(n), (size_t)(s), (cmp_t)(cmp))

#define BSEARCH(key,base,n,s,cmp) \
	bsearch(key, base, (size_t)(n), (size_t)(s), (cmp_t)(cmp))

/* For Error(): */
#define kDoPerror		1
#define kDontPerror		0

#define kClosedFileDescriptor (-1)

#define SZ(a) ((size_t) (a))

typedef void (*Sig_t)(int);
typedef volatile Sig_t VSig_t;

#define SIGNAL(a,proc) signal((a), (Sig_t)(proc))
#define kNoSignalHandler ((Sig_t) -96)

#ifndef F_OK
#	define F_OK 0
#endif

#ifdef HAVE_REMOVE
#	define UNLINK remove
#else
#	define UNLINK unlink
#endif

#ifndef SEEK_SET
#	define SEEK_SET    0
#	define SEEK_CUR    1
#	define SEEK_END    2
#endif  /* SEEK_SET */

#ifdef SETVBUF_REVERSED
#	define SETVBUF(a,b,c,d) setvbuf(a,c,b,d)
#else
#	define SETVBUF setvbuf
#endif

/* Util.c */
char *FGets(char *, size_t, FILE *);
struct passwd *GetPwByName(void);
void GetHomeDir(char *, size_t);
void GetUserName(char *, size_t);
void CloseFile(FILE **);
void PrintF(const FTPCIPtr, char *, ...);
void Error(const FTPCIPtr, int, char *, ...);
time_t UnMDTMDate(char *);
void Scramble(unsigned char *dst, size_t dsize, unsigned char *src, char *key);

#endif	/* _util_h_ */
