// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/Scheduling.subproj/OFScheduledEvent.h,v 1.3 1998/12/08 04:08:33 kc Exp $

#import "OFObject.h"

@class NSDate;
@class OFInvocation;

@interface OFScheduledEvent : OFObject
{
    OFInvocation *invocation;
    NSDate *date;
}

- initWithInvocation:(OFInvocation *)anInvocation atDate:(NSDate *)aDate;
- initForObject:(id)anObject selector:(SEL)aSelector withObject:(id)aWithObject atDate:(NSDate *)date;

- (OFInvocation *)invocation;
- (NSDate *)date;

- (void)invoke;

- (NSComparisonResult)compare:(id)otherEvent;
- (unsigned int)hash;
- (BOOL)isEqual:(id)anObject;

@end
