// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OpenStepExtensions.subproj/NSFileManager-OFExtensions.h,v 1.15 1998/12/08 04:08:16 kc Exp $

#import <Foundation/NSFileManager.h>
#import <OmniBase/SystemType.h>
#import "FrameworkDefines.h"

@class NSNumber;

@interface NSFileManager (OFExtensions)

- (NSString *)tempFilenameFromTemplate:(NSString *)inputString
    andRange:(NSRange)replaceRange;
    // Create a unique temp filename from a template filename, given a range within the template filename which identifies where the unique portion of the filename is to lie.

- (NSString *)tempFilenameFromTemplate:(NSString *)inputString
    andPosition:(int)position;
    // Create a unique temp filename from a template string, given a position within the template filename which identifies where the unique portion of the filename is to begin.

- (NSString *)tempFilenameFromTemplate:(NSString *)inputString
    andSubstring:(NSString *)substring;
    // Create a unique temp filename from a template string, given a substring within the template filename which is to be replaced by the unique portion of the filename.

- (NSString *)tempFilenameFromHashesTemplate:(NSString *)inputString;
    // Create a unique temp filename from a template string which contains a substring of six hash marks which are to be replaced by the unique portion of the filename.

- (NSString *)uniqueFilenameFromName:(NSString *)suggestedName;
    // Generate a unique filename based on a suggested name
    // Note: Does not work properly on Windows at the moment because it is hardcoded to use forward slashes rather than using the native path separator.

// Scratch files

- (NSString *)scratchDirectoryPath;
- (NSString *)scratchFilenameNamed:(NSString *)aName;
- (void)removeScratchDirectory;

// Changing file access/update timestamps.

- (void)touchFile:(NSString *)filePath;

// Directory manipulations

- (BOOL)directoryExistsAtPath:(NSString *)path;
- (void)createPathToFile:(NSString *)path attributes:(NSDictionary *)attributes;
    // Creates any directories needed to be able to create a file at the specified path.  Raises an exception on failure.

- (NSString *)existingPortionOfPath:(NSString *)path;

//

- (NSNumber *)posixPermissionsForMode:(unsigned int)mode;
- (NSNumber *)defaultFilePermissions;
- (NSNumber *)defaultDirectoryPermissions;

- (NSString *)networkMountPointForPath:(NSString *)path returnMountSource:(NSString **)mountSource;

@end
