// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSDictionary-OFExtensions.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import "NSArray-OFExtensions.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OpenStepExtensions.subproj/NSDictionary-OFExtensions.m,v 1.4 1998/12/08 04:08:15 kc Exp $")

NSString *OmniDictionaryElementNameKey = @"__omniDictionaryElementNameKey";

@implementation NSDictionary (OFExtensions)

- (id)anyObject;
{
    return [[self allValues] anyObject];
}

- (NSDictionary *)elementsAsInstancesOfClass:(Class)aClass withContext:(id)context;
{
    NSMutableDictionary        *dict;
    NSAutoreleasePool          *pool;
    NSEnumerator               *elementEnum;
    NSString                   *elementName;

    // Keep this out of the pool since we're returning it
    dict = [NSMutableDictionary dictionary];

    pool = [[NSAutoreleasePool alloc] init];
    elementEnum = [self keyEnumerator];
    while ((elementName = [elementEnum nextObject])) {
	id instance;
	NSMutableDictionary *element;

	element = [[NSMutableDictionary alloc] initWithDictionary:[self objectForKey:elementName]];
	[element setObject:elementName forKey:OmniDictionaryElementNameKey];

	instance = [[aClass alloc] initWithDictionary:element context:context];
	[element release];

	[dict setObject:instance forKey:elementName];
    }
    [pool release];

    return dict;
}

- (NSString *)keyForObjectEqualTo:(id)anObject;
{
    NSEnumerator *selfEnum;
    NSString *aKey;

    selfEnum = [self keyEnumerator];
    while ((aKey = [selfEnum nextObject]))
        if ([[self objectForKey:aKey] isEqual:anObject])
	    return aKey;
    return nil;
}

- (float)floatForKey:(NSString *)key defaultValue:(float)defaultValue;
{
    id value;

    value = [self objectForKey:key];
    if (value)
        return [value floatValue];
    return defaultValue;
}

- (float)floatForKey:(NSString *)key;
{
    return [self floatForKey:key defaultValue:0.0];
}

- (double)doubleForKey:(NSString *)key defaultValue:(double)defaultValue;
{
    id value;

    value = [self objectForKey:key];
    if (value)
        return [value doubleValue];
    return defaultValue;
}

- (double)doubleForKey:(NSString *)key;
{
    return [self doubleForKey:key defaultValue:0.0];
}

- (BOOL)boolForKey:(NSString *)key defaultValue:(BOOL)defaultValue;
{
    id value;

    value = [self objectForKey:key];
    if (!value)
        return defaultValue;

    if (![value isKindOfClass:[NSString class]])
        // Should maybe raise an error here?
        return NO;

    // Should maybe later add a configurable dictionary that contains
    // the valid YES and NO values
    if ([value isEqual:@"YES"] || [value isEqual:@"Y"] || [value isEqual:@"yes"] || [value isEqual:@"y"] || [value isEqual:@"1"])
        return YES;
    else
        return NO;
}

- (BOOL)boolForKey:(NSString *)key;
{
    return [self boolForKey:key defaultValue:NO];
}

- (int)intForKey:(NSString *)key defaultValue:(int)defaultValue;
{
    id value;

    value = [self objectForKey:key];
    if (!value)
        return defaultValue;
    return [value intValue];
}

- (int)intForKey:(NSString *)key;
{
    return [self intForKey:key defaultValue:0];
}

- (id)objectForKey:(NSString *)key defaultObject:(id)defaultObject;
{
    id value;

    value = [self objectForKey:key];
    if (value)
        return value;
    return defaultObject;
}

- (NSMutableDictionary *)deepMutableCopy;
{
    NSMutableDictionary *ret;
    NSEnumerator *selfEnum;
    id anObject;
    id aKey;

    ret = [self mutableCopy];
    selfEnum = [[ret allKeys] objectEnumerator];
    while ((aKey = [selfEnum nextObject])) {
        anObject = [ret objectForKey:aKey];
        if ([anObject respondsToSelector:@selector(deepMutableCopy)])
            [ret setObject:[anObject deepMutableCopy] forKey:aKey];
        else if ([anObject respondsToSelector:@selector(mutableCopy)])
            [ret setObject:[anObject mutableCopy] forKey:aKey];
    }

    return ret;
}

@end


@implementation NSDictionary (DeprecatedOFExtensions)

- (id)valueForKey:(NSString *)key defaultValue:(id)defaultValue;
{
    return [self objectForKey:key defaultObject:defaultValue];
}

@end
