// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSDate-OFExtensions.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

// This is not included in OmniBase.h since system.h shouldn't be used except when covering OS specific behaviour
#import <OmniBase/system.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/OpenStepExtensions.subproj/NSDate-OFExtensions.m,v 1.2 1998/12/08 04:08:15 kc Exp $")

@implementation NSDate (OFExtensions)

- (void)sleepUntilDate;
{
    NSTimeInterval              timeIntervalSinceNow;
    struct timeval              selectTimeout;

    timeIntervalSinceNow = [self timeIntervalSinceNow];
    if (timeIntervalSinceNow < 0)
	return;
    selectTimeout.tv_sec = timeIntervalSinceNow;
    selectTimeout.tv_usec = 1.0e6 *
      (timeIntervalSinceNow - selectTimeout.tv_sec);
    select(0, NULL, NULL, NULL, &selectTimeout);
}

@end
