// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OFTrieBucket.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniFoundation/DataStructures.subproj/OFTrieBucket.m,v 1.3 1998/12/08 04:08:07 kc Exp $")

@implementation OFTrieBucket

- (void)setRemainingLower:(unichar *)lower upper:(unichar *)upper length:(int)aLength;
{
    unichar *old;
    NSZone *myZone = [self zone];

    old = lowerCharacters;
    if (lower && upper && aLength > 0) {
        lowerCharacters = (unichar *)NSZoneMalloc(myZone, 2 * (aLength + 1) * sizeof(unichar));
        memmove(lowerCharacters, lower, aLength * sizeof(unichar));
        lowerCharacters[aLength] = '\0';
        upperCharacters = lowerCharacters + aLength + 1;
        memmove(upperCharacters, upper, aLength * sizeof(unichar));
        upperCharacters[aLength] = '\0';
    } else {
        lowerCharacters = (unichar *)NSZoneMalloc(myZone, 2 * sizeof(unichar));
	upperCharacters = lowerCharacters + 1;
	*lowerCharacters = '\0';
	*upperCharacters = '\0';
    }
    if (old)
        NSZoneFree(myZone, old);
}

- (void)dealloc;
{
    NSZoneFree([self zone], lowerCharacters);
    [super dealloc];
}

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary        *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (lowerCharacters) {
        unsigned int length;
        unichar *ptr;

        ptr = lowerCharacters;
        length = 0;
        while (*ptr++)
	    length++;

	[debugDictionary setObject:[NSString stringWithCharacters:lowerCharacters length:length] forKey:@"lowerCharacters"];
	[debugDictionary setObject:[NSString stringWithCharacters:upperCharacters length:length] forKey:@"upperCharacters"];
    }
    return debugDictionary;
}

@end
