#import <AppKit/AppKit.h>

typedef int JobPriority;

#define	P_LOW		100
#define	P_STANDARD	50
#define	P_HIGH		10
#define	P_FILL		9
#define	P_MAX		0

#import "ContextProtocol.h"
#import "LayerProtocol.h"

@class Document, ThreadState, EngineData;

@interface Engine: NSObject
{
	// this is the ONLY variable you may be interested in changing:
	// all TIFFany engines set it to YES if successful,
	// to NO if some sort of failure occured.
	int					returnCode;


	// document / context state
	// READ ONLY VARIABLES - do never, ever set them	
	// these variables are set automatically for you
	// a context can be "nil" - such as for virtual documents.
	id <Layer>    			layer;
	Document				*document;
	id <Context>			context;
	
@private
//--------------------------------------------------------------------
	// DO NOT TOUCH ANY OF THE variables below this line
	// do not rely on any information in these variables
	// or serious malfunction may result. do not rely
	// on any meaningful (read) data. NOTE: MULTITHREADED
	//
	// kernel flags
	NSDate				*creation;
	int					uniqueStamp;
	JobPriority			priority;
	ThreadState			*state;
	NSString				*description;

	// synchronization / displaying
	NSConditionLock		*pauseLock;
	NSString				*engineTitle;

@protected
	// kernel interface variables
	volatile double		progress;
	volatile BOOL			paused;
	volatile BOOL			abort;
	volatile BOOL			running;
	volatile BOOL			nice;
	volatile BOOL			batch;
	volatile BOOL			excluded;

	// this is a HACK for performance reasons ONLY
@public
	volatile BOOL			suspended;
	volatile BOOL			clean;
}

- initWithEngineData: (EngineData *)data;
- (void)dealloc;

// private
- (void) setDocument:(Document *)d;
- (Document *) document;

// the context in which an engine runs
// see ContextProtocol
- (void) setContext:(id <Context>)c;
- (id <Context>) context;

// priority at which an egnine runs
- (void) setPriority:(JobPriority)p;
- (JobPriority) priority;

// Kernel flags - DO NOT ALTER OR OTHERWISE INTERFERE
- (int) uniqueStamp;
- (ThreadState *) threadState;

// sets whether engine is excluded from process panel
// and whether it's a batch engine - handled by kernel
- (void) setIsExcluded:(BOOL)e;
- (void) setIsBatch:(BOOL)b;
- (BOOL) isBatch;


// messages before launch - message super FIRST
- (void)preLaunchMainThread;
- (void)preLaunchExecThread;

// your core code here -- see example
- (void)runEngine;

// messages before engine ends - message super LAST
- (void)postEndExecThread;
- (void)postEndMainThread;


// title of engine - should NOT be altered once set
- (void)setTitle: (NSString *)title;
- (NSString *)title;


// in your subclass, query this state if you want to support "abort"
- (BOOL)isAborted;

// a double value between 0...1
- (double)progress;

// returns the value of the return code variable
- (int)returnCode;

// synchronization mechanism - DO NOT INVOKE
- (void)setIsPaused: (BOOL)flag;
- (void)waitPause;
- (BOOL)isPaused;
- (void)abortEngine;

@end
