// Copyright 1997 Caffeine Software
// The API is sublect to change without prior notice
// You can freely use any elements of this public API
// Caffeine Software is not liable for any malfunctions of the API
//
// stanj 10-4-1997

/*--------------------------------------------------------------------*\
|*				this is the public document protocol			*|
|*			this protocol is implemented by all elements			*|
|*			of a "context" - such as window, view, etc.			*|
|*			the API allows access only to *A* context			*|
|*			and not to any specific elements of the documents		*|
\*--------------------------------------------------------------------*/

#import "LayerProtocol.h"

@protocol Context <NSObject>

- (NSRect) visibleRect;				// rectangle currently visible
- (NSRect) boundingBox;				// "frame" bounding box
- (BOOL) isIdle;					// any engines running?

// following two methods useful only in GUI for engines, if at all
- (id <Layer>) toProcessLayer;		// layer to be processed
								// useful for GUI such as Resize
								// or crop - you can query size etc.

- (NSArray *) toProcessMarquees;		// array of (id <Marquee>)
								// objects - you can query their
								// bounds etc., if required


- (void) displayAll;				// forces display of all 
								// (clone) views of the document
- (void) displayView;				// forces display of the 
								// receiving context only

- (double) currentZoom;				// zoom in current context

@end
