/*****************************************************************************\
**                                                                           **
**  CSPixel.h                                       R. Brunner, Sep 08 1994  **
**                                               (C) 1993 Caffeine Software  **
**                                                                           **
**  Functions for accessing the RGBPixel and CMYKPixel structures.           **
**                                                                           **
\*****************************************************************************/

#import <AppKit/AppKit.h>

#ifndef uchar
#  define uchar          unsigned char
#endif

#ifndef ushort
#  define ushort         unsigned short
#endif

#ifndef ulong
#  define ulong          unsigned long
#endif

#ifndef CHANNEL_MAX
#  define CHANNEL_SHIFT  (8)
#  define CHANNEL_MAX    ((1 << CHANNEL_SHIFT) - 1)
#endif

#ifndef HUE_MAX
#  define HUE_MAX        (3600)
#endif

#ifndef WEIGHTSHIFT
#  define WEIGHTSHIFT    (8)
#endif


typedef struct
{
     uchar     c,m,y,k,a;
} CMYKAPixel;

typedef struct
{
     uchar     r,g,b,a;
} RGBAPixel;


extern int     CSWeightR;
extern int     CSWeightG;
extern int     CSWeightB;


/*********************************************** Conversion from/to NXColor **/

extern NSColor *CSColorFromRGBAPixel(RGBAPixel *p);
extern NSColor *CSColorFromCMYKAPixel(CMYKAPixel *p);
extern void    CSRGBAPixelFromColor(NSColor * c, RGBAPixel *p);
extern void    CSCMYKAPixelFromColor(NSColor * c, CMYKAPixel *p);


/********************************************************* k-Ratio Handling **/

extern ushort  CSCMYKAPixelKRatio(CMYKAPixel *p);
extern void    CSSetCMYKAPixelKRatio(CMYKAPixel *p, ushort r);


/**************************************** Conversion between CMYKA and RGBA **/

extern void CSConvertCMYKAToRGBAPixel(CMYKAPixel *p, RGBAPixel *q);
extern void CSConvertRGBAToCMYKAPixel(RGBAPixel *p, CMYKAPixel *q, ushort r);


/******************************************************* Intensity Handling **/

extern ushort  CSRGBAPixelIntensity(RGBAPixel *p);
extern ushort  CSCMYKAPixelIntensity(CMYKAPixel *p);
extern void    CSSetRGBAPixelIntensity(RGBAPixel *p, ushort i);
extern void    CSSetCMYKAPixelIntensity(CMYKAPixel *p, ushort i);


/************************************************************* Hue Handling **/

extern ushort  CSRGBAPixelHue(RGBAPixel *p);
extern ushort  CSCMYKAPixelHue(CMYKAPixel *p);
extern void    CSSetRGBAPixelHue(RGBAPixel *p, ushort i);
extern void    CSSetCMYKAPixelHue(CMYKAPixel *p, ushort i);


/****************************************************** Saturation Handling **/

extern ushort  CSRGBAPixelSaturation(RGBAPixel *p);
extern ushort  CSCMYKAPixelSaturation(CMYKAPixel *p);
extern void    CSSetRGBAPixelSaturation(RGBAPixel *p, ushort i);
extern void    CSSetCMYKAPixelSaturation(CMYKAPixel *p, ushort i);


/****************************************************** Brightness Handling **/

extern ushort  CSRGBAPixelBrightness(RGBAPixel *p);
extern ushort  CSCMYKAPixelBrightness(CMYKAPixel *p);
extern void    CSSetRGBAPixelBrightness(RGBAPixel *p, ushort i);
extern void    CSSetCMYKAPixelBrightness(CMYKAPixel *p, ushort i);


/********************************************************** Other Functions **/

static inline ushort CSTruncateChannel(int t)
{
     return (t > 0)  ?  (t < CHANNEL_MAX)  ?  t  :  CHANNEL_MAX  :  0;
}

static inline BOOL CSEqualRGBAPixel(RGBAPixel *a, RGBAPixel *b)
{
     return    (a->r == b->r)  &&  (a->g == b->g)  &&
               (a->b == b->b)  &&  (a->a == b->a);
}

static inline BOOL CSEqualCMYKAPixel(CMYKAPixel *a, CMYKAPixel *b)
{
     return    (a->c == b->c)  &&  (a->m == b->m)  &&  (a->y == b->y)  &&
               (a->k == b->k)  &&  (a->a == b->a);
}
