/*****************************************************************************\
**                                                                           **
**  CSMeasurementUnit.h                             R. Brunner, Mar 21 1995  **
**                                               (C) 1995 Caffeine Software  **
**                                                                           **
**  Implementation of units. Supported units: inch, point, point pica,       **
**  meter and pixels.                                                        **
**                                                                           **
\*****************************************************************************/

#import <Foundation/NSObject.h>

typedef enum
{
     CSUNIT_INCH,
     CSUNIT_PICA,
     CSUNIT_POINT,
     CSUNIT_PIXEL,
     CSUNIT_METER,
     CSUNIT_CENTIMETER,
     CSUNIT_MILLIMETER
} CSUnit;


@interface CSMeasurementUnit: NSObject
{
     double    value;
     CSUnit    unit;
}

- initWithStringValue: (NSString *)string;
- initWithValue: (double)v  inUnit: (CSUnit)u;

- copy;
- copyWithZone: (NSZone *)zone;

- (CSUnit)measurementUnit;
- (void)setMeasurementUnit: (CSUnit)u;
- (void)setMeasurementUnit: (CSUnit)u  dpi: (double)d;

- (NSString *)stringValue;
- (NSString *)stringValueInUnit: (CSUnit)u;
- (NSString *)stringValueInUnit: (CSUnit)u  dpi: (double)d;
- (NSString *)fullStringValue;

- (void)roundToDigits;

- (double)value;
- (double)valueInUnit: (CSUnit)u;
- (double)valueInUnit: (CSUnit)u  dpi: (double)d;

- (void)setValue: (double)v;
- (void)setValue: (double)v  inUnit: (CSUnit)u;
- (void)setStringValue: (NSString *)string;

@end
