/* BundleMain.h created by stanj on Tue 24-Dec-1996 */

#import <AppKit/AppKit.h>

@interface BundleMain : NSObject
{

}

// you MUST supply data for this
// implicitly, an returned name is assumed to be an action
// if it is a modifier, it should be followed by a ".M" suffix
// if it is an extension, it should be followed by a ".X" suffix
// (a ".A" suffix is optional for an action)
+ (NSArray *) bundleClassRootNames;

// overriding this is OPTIONAL. The kernel will attempt
// to use a localized string table "DisplayNames.strings" to resolve
// based on language without your programming efforts.
// In this string table, you must NOT use the suffixes described above.
// If not found, the class root names will be used. If overridden,
// you are responsible to return the names in the same order
// as in "bundleClassRootNames"
+ (NSArray *) bundleClassDisplayNames;

// You should NOT directly override this method.
// this method returns either "nil" or an array with precisely the same
// mumber of strings as the above two. Each string contains the name of
// a subgroup in which the class should be displayed. If the string is
// empty, the entry will be displayed at root level.
//
// The kernel will automatically attempt to resolve
// the localized table "CategoryNames.strings".
+ (NSArray *) bundleClassCategoryNames;

// BUNDLE-wide localized string table "Localized.strings"
+ (NSDictionary *) mainStringTable;
+ (NSString *) localizedStringForKey:(NSString *)key;

// DO NOT override these methods unless you want some 
// special behavior

+ (NSImage *) iconForClassRootName:(NSString *)s;

@end
