#import <AppKit/AppKit.h>

#import "EngineData.h"

#import "Compositing.h"

extern NSString *compositingKey;
extern NSString *boundsTypeKey;
extern NSString *intensityKey;

@interface ActionData:EngineData
{
}

- (double) intensity;
- (void) setIntensity:(double)i;

- (void)dragAt: (NSPoint)point offset: (NSSize)offset event: (NSEvent *)event;

// this is for individual recognition whether an action could
// define a mask. makes the number of false positives (based on interface
// class methods) smaller. For the Create Mask button to be enabled,
// this method must return YES -- set automatically based on the Inspector switch
// you may want to set the default value in the default setup call

- (void) setCanDefineMask:(BOOL)yn;
- (BOOL) canDefineMask;		// default is NO

// bounds type: can be either by layer, marquee or document
+ (BoundsType) tagForBoundsTypeNamed:(NSString *)bt;
+ (NSString *) boundsTypeNameForTag:(BoundsType)bt;

- (NSString *) boundsType;
- (void) setBoundsType:(NSString *)c;
- (BoundsType) boundsTypeTag;

@end
